function dotProduct(v1, v2) {
    return v1.map((c, i) => c * v2[i]).reduce((p, c) => p + c, 0);
}

function vecSubtract(v1, v2) {
    return v1.map((c, i) => c - v2[i]);
}

function vecLength(v) {
    return Math.sqrt(dotProduct(v, v));
}

function vecDist(v1, v2) {
    return vecLength(vecSubtract(v1, v2));
}

function interpolate(f1, f2, a) {
    return f1 * (1. - a) + f2 * a;
}

function smoothstep(x) {
    return x < 0 ? 0 : x > 1 ? 1 : 3 * x * x - 2 * x * x * x;
}